/*
 * Decompiled with CFR 0.152.
 */
package be.jorenfabre.mygame;

import be.jorenfabre.mygame.commands.CommandParser;
import be.jorenfabre.mygame.commands.CommandProcessor;
import be.jorenfabre.mygame.entities.Player;
import be.jorenfabre.mygame.utilities.ItemManager;
import be.jorenfabre.mygame.utilities.PersonManager;
import be.jorenfabre.mygame.utilities.RoomManager;
import be.jorenfabre.mygame.utilities.Solution;
import java.util.Scanner;

public class MyGame {
    private static MyGame instance;
    private Player player;
    private Player otherPlayer;
    private CommandParser parser;
    private int attempts;

    public MyGame() {
        instance = this;
        Scanner scanner = new Scanner(System.in);
        System.out.println("Before we begin, what are your name and title?");
        System.out.print("\u27a4 My first name is ");
        String fName = scanner.nextLine();
        System.out.print("\u27a4 My last name is ");
        String lName = scanner.nextLine();
        System.out.print("\u27a4 My title is ");
        String title = scanner.nextLine();
        this.otherPlayer = this.player = new Player(title + " " + lName, RoomManager.createRooms(true), true);
        this.player = new Player(fName, RoomManager.createRooms(false), false);
        this.parser = new CommandParser();
        this.attempts = 3;
        ItemManager.spawnItems();
        PersonManager.spawnPeople();
        Solution.setSolution();
        this.play();
    }

    public static MyGame getInstance() {
        return instance;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void passPortal() {
        Player temp = this.otherPlayer;
        this.otherPlayer = this.player;
        this.player = temp;
    }

    public boolean useAttempt() {
        --this.attempts;
        return this.attempts > 0;
    }

    public int getRemainingAttempts() {
        return this.attempts;
    }

    private void play() {
        this.printWelcome();
        Enum ending = null;
        while (ending == null) {
            ending = CommandProcessor.processCommand(this.parser.getNextCommand());
        }
        switch (1.$SwitchMap$be$jorenfabre$mygame$utilities$GameEnding[ending.ordinal()]) {
            case 1: {
                this.printExitWin();
                break;
            }
            case 2: {
                this.printExitLose();
                break;
            }
        }
        this.parser.close();
    }

    private void printWelcome() {
        System.out.println();
        System.out.println();
        System.out.println("Welcome to My Game, " + this.player.getName());
        System.out.println("You have been asked to solve the murder of Dr. Black, the late owner of this mansion.");
        System.out.println("You will have to walk around the mansion to gather items and information.");
        System.out.println("The only information you have so far is that the only item that");
        System.out.println("  could have been moved since the murder must be the murder weapon.");
        System.out.println();
        System.out.println("To see a list of commands use 'help'.");
        System.out.println("Good luck!");
    }

    private void printExitWin() {
        System.out.println("Congratulations!");
        System.out.println("You have solved the murder!");
        System.out.println("You had " + this.attempts + " attempts left.");
        System.out.println();
        System.out.println("Thank you for playing.");
        System.out.println("If you have any comments or suggestions for my game let me know.");
    }

    private void printExitLose() {
        System.out.println("You used all your attempts and still didn't get it right");
        System.out.println("Thank you for trying.");
        System.out.println();
        System.out.println("If you have any comments or suggestions for my game let me know.");
    }

    public static void main(String[] args) {
        new MyGame();
    }
}

