/*
 * Decompiled with CFR 0.152.
 */
package be.jorenfabre.mygame.commands;

import be.jorenfabre.mygame.MyGame;
import be.jorenfabre.mygame.commands.Command;
import be.jorenfabre.mygame.commands.CommandWord;
import be.jorenfabre.mygame.entities.Item;
import be.jorenfabre.mygame.entities.LostPerson;
import be.jorenfabre.mygame.entities.Player;
import be.jorenfabre.mygame.map.Room;
import be.jorenfabre.mygame.map.exit.Exit;
import be.jorenfabre.mygame.map.exit.ExitDirection;
import be.jorenfabre.mygame.map.exit.ExitRequirement;
import be.jorenfabre.mygame.utilities.GameEnding;
import be.jorenfabre.mygame.utilities.ItemManager;
import be.jorenfabre.mygame.utilities.PersonManager;
import be.jorenfabre.mygame.utilities.RoomManager;
import be.jorenfabre.mygame.utilities.Solution;
import java.util.ArrayList;
import java.util.Scanner;

public class CommandProcessor {
    public static GameEnding processCommand(Command command) {
        if (command == null || command.getCommand() == null) {
            System.out.println("Unknown command");
            return null;
        }
        if ((command = new Command(command, CommandProcessor.getCommand(command))).getArguments().length != command.getCommand().getArguments()) {
            System.out.println("Invalid arguments!");
            System.out.println("Usage: " + command.getCommand().getUsage());
            return null;
        }
        switch (command.getCommand()) {
            case GO: {
                CommandProcessor.go(command);
                break;
            }
            case LOOK: {
                CommandProcessor.look();
                break;
            }
            case SEARCH: {
                CommandProcessor.search();
                break;
            }
            case SEE: {
                CommandProcessor.see();
                break;
            }
            case BACK: 
            case BACK_MULTI: {
                CommandProcessor.back(command);
                break;
            }
            case HELP: 
            case HELP_COMMAND: {
                CommandProcessor.help(command);
                break;
            }
            case UNLOCK: {
                CommandProcessor.unlock(command);
                break;
            }
            case INVENTORY: {
                CommandProcessor.inventory();
                break;
            }
            case PICKUP: {
                CommandProcessor.pickup(command);
                break;
            }
            case DROP: {
                CommandProcessor.drop(command);
                break;
            }
            case SOLVE: {
                return CommandProcessor.solve(command);
            }
            case QUIT: {
                if (!CommandProcessor.quit(command)) break;
                return GameEnding.LEAVE;
            }
        }
        return null;
    }

    private static CommandWord getCommand(Command command) {
        if (command.getCommand() == null) {
            return null;
        }
        CommandWord backup = command.getCommand();
        for (CommandWord commandWord : CommandWord.values()) {
            if (command.getCommand().getName().equals(commandWord.getName()) && command.getArguments().length == commandWord.getArguments()) {
                return commandWord;
            }
            if (!command.getCommand().getName().equals(commandWord.getName())) continue;
            backup = commandWord;
        }
        return backup;
    }

    private static ExitDirection getDirection(String direction) {
        switch (direction = direction.trim().toLowerCase()) {
            case "north": 
            case "n": {
                return ExitDirection.NORTH;
            }
            case "northwest": 
            case "nw": {
                return ExitDirection.NORTHWEST;
            }
            case "northeast": 
            case "ne": {
                return ExitDirection.NORTHEAST;
            }
            case "west": 
            case "w": {
                return ExitDirection.WEST;
            }
            case "portal": 
            case "p": {
                return ExitDirection.PORTAL;
            }
            case "east": 
            case "e": {
                return ExitDirection.EAST;
            }
            case "south": 
            case "s": {
                return ExitDirection.SOUTH;
            }
            case "southwest": 
            case "sw": {
                return ExitDirection.SOUTHWEST;
            }
            case "southeast": 
            case "se": {
                return ExitDirection.SOUTHEAST;
            }
        }
        return null;
    }

    private static void go(Command command) {
        if (command.getArguments().length != 1) {
            command.getCommand().printUsage();
            return;
        }
        MyGame.getInstance().getPlayer().goDirection(CommandProcessor.getDirection(command.getArguments()[0]));
    }

    private static void look() {
        System.out.println(MyGame.getInstance().getPlayer().getCurrentRoom());
    }

    private static void search() {
        MyGame.getInstance().getPlayer().getCurrentRoom().printItems();
    }

    private static void see() {
        Player player = MyGame.getInstance().getPlayer();
        if (!player.isPastPlayer()) {
            System.out.println("You cannot use this command right now.");
            return;
        }
        System.out.println("People currently in the " + player.getCurrentRoom().getName() + " with you:");
        if (PersonManager.getPeopleInRoom(player.getCurrentRoom()).isEmpty()) {
            System.out.println("None.");
        } else {
            PersonManager.getPeopleInRoom(player.getCurrentRoom()).forEach(System.out::println);
        }
    }

    private static void back(Command command) {
        if (command.getArguments().length == 0) {
            Exit exit = MyGame.getInstance().getPlayer().goBack();
            if (exit == null) {
                System.out.println("You have nowhere left to go back to!");
                return;
            }
            if (exit.isLocked()) {
                if (exit.getRequirement() == ExitRequirement.WRONG_WAY) {
                    System.out.println("This door seems to only open from the other side.");
                    System.out.println("Unable to go back through it.");
                } else {
                    System.out.println("This exit is locked!");
                    System.out.println("Unable to go back through it right now.");
                }
            } else {
                System.out.println("You went back to the " + exit.getRoom().getName() + ".");
            }
        } else if (command.getArguments().length == 1) {
            try {
                int amount = Integer.parseInt(command.getArguments()[0]);
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid number: " + command.getArguments()[0]);
                return;
            }
            for (int i = amount; i > 0; --i) {
                Exit exit = MyGame.getInstance().getPlayer().goBack();
                if (exit == null) {
                    System.out.println("You have nowhere left to go back to!");
                    return;
                }
                if (exit.isLocked()) {
                    if (exit.getRequirement() == ExitRequirement.WRONG_WAY) {
                        System.out.println("This door seems to only open from the other side.");
                        System.out.println("Unable to go back through it.");
                    } else {
                        System.out.println("This exit is locked!");
                        System.out.println("Unable to go back through it right now.");
                    }
                    break;
                }
                System.out.printf("You go %s, back to the %s. (%d left)%n", new Object[]{exit.getDirection(), exit.getRoom().getName(), i - 1});
            }
        } else {
            command.getCommand().printUsage();
        }
    }

    private static void help(Command command) {
        if (command.getArguments().length == 0) {
            System.out.print("Commands: ");
            ArrayList<String> commands = new ArrayList<String>();
            for (CommandWord word : CommandWord.values()) {
                if (commands.contains(word.getName())) continue;
                System.out.print(word.getName() + " ");
                commands.add(word.getName());
            }
        } else if (command.getArguments().length == 1) {
            CommandWord commandWord;
            switch (command.getArguments()[0].toLowerCase()) {
                case "go": {
                    commandWord = CommandWord.GO;
                    break;
                }
                case "look": {
                    commandWord = CommandWord.LOOK;
                    break;
                }
                case "search": {
                    commandWord = CommandWord.SEARCH;
                    break;
                }
                case "see": {
                    commandWord = CommandWord.SEE;
                    break;
                }
                case "back": {
                    System.out.printf("Usage: %s (%s)%nOR %s (%s)%n", CommandWord.BACK.getUsage(), CommandWord.BACK.getDescription(), CommandWord.BACK_MULTI.getUsage(), CommandWord.BACK_MULTI.getDescription());
                    return;
                }
                case "help": {
                    System.out.printf("Usage: %s (%s)%nOR %s (%s)%n", CommandWord.HELP.getUsage(), CommandWord.HELP.getDescription(), CommandWord.HELP_COMMAND.getUsage(), CommandWord.HELP_COMMAND.getDescription());
                    return;
                }
                case "unlock": {
                    commandWord = CommandWord.UNLOCK;
                    break;
                }
                case "inventory": {
                    commandWord = CommandWord.INVENTORY;
                    break;
                }
                case "pickup": {
                    commandWord = CommandWord.PICKUP;
                    break;
                }
                case "drop": {
                    commandWord = CommandWord.DROP;
                    break;
                }
                case "solve": {
                    commandWord = CommandWord.SOLVE;
                    break;
                }
                case "quit": {
                    commandWord = CommandWord.QUIT;
                    break;
                }
                default: {
                    System.out.println("Unknown command. Use command 'help' for a list of commands");
                    return;
                }
            }
            System.out.printf("Command %s: %s%nUsage: %s%n", commandWord.getName(), commandWord.getDescription(), commandWord.getUsage());
        } else {
            command.getCommand().printUsage();
        }
    }

    private static void unlock(Command command) {
        if (command.getArguments().length != 2) {
            command.getCommand().printUsage();
            return;
        }
        Player player = MyGame.getInstance().getPlayer();
        ExitDirection direction = CommandProcessor.getDirection(command.getArguments()[0]);
        if (direction == null) {
            System.out.println("Unknown direction!");
            System.out.println("Use 'look' to see all exits in this room.");
            return;
        }
        Item item = ItemManager.getItem(command.getArguments()[1]);
        if (item == null || !player.hasInventoryItem(item)) {
            System.out.println("You don't have any item with that item ID.");
            return;
        }
        if (!player.getCurrentRoom().isExit(direction)) {
            System.out.println("There is no exit that way!");
            System.out.println("Use 'look' to see all exits in this room.");
            return;
        }
        Exit exit = player.getCurrentRoom().getExit(direction);
        if (!exit.isLocked()) {
            System.out.println("This exit is already unlocked!");
            System.out.println("Use 'go' to go through this exit and to the " + exit.getRoom().getName());
            return;
        }
        if (!exit.getRequirement().hasItem()) {
            System.out.println("Unable to unlock.");
            System.out.println("Maybe it's a one-way door?");
            return;
        }
        if (!exit.getRequirement().getItem().equals(item)) {
            System.out.println("The door doesn't seem to unlock.");
            System.out.println("Either you tried the wrong key or you don't have the correct one yet.");
            return;
        }
        exit.setUnlocked();
        Exit otherWay = exit.getRoom().getExit(direction.getOpposite());
        if (otherWay != null && exit.getRequirement() == otherWay.getRequirement()) {
            otherWay.setUnlocked();
        }
        if (exit.getRequirement() == ExitRequirement.PORTAL_ACCESS) {
            player.breakTalisman();
            System.out.println("The portal opens, but the talisman you used to open it breaks.");
            System.out.println("You can now enter the portal using 'go'.");
        } else {
            System.out.println("You manage to get the door unlocked.");
            System.out.println("You can now use this door with 'go'.");
        }
    }

    private static void inventory() {
        MyGame.getInstance().getPlayer().printInventory();
    }

    private static void pickup(Command command) {
        if (command.getArguments().length != 1) {
            command.getCommand().printUsage();
            return;
        }
        Item item = ItemManager.getItem(command.getArguments()[0]);
        if (item == null || !MyGame.getInstance().getPlayer().getCurrentRoom().hasItem(item)) {
            System.out.println("Cannot find item!");
            System.out.println("Use 'search' to see what items are in your current room.");
            return;
        }
        if (MyGame.getInstance().getPlayer().pickupItem(item)) {
            System.out.println("You have picked up " + item.getName() + ".");
            System.out.println("Use 'inventory' to see the items you have with you.");
        } else {
            System.out.println("You are unable to pick " + item.getName() + " up.");
            System.out.println("Use 'drop' to make room for it.");
        }
    }

    private static void drop(Command command) {
        if (command.getArguments().length != 1) {
            command.getCommand().printUsage();
            return;
        }
        Item item = ItemManager.getItem(command.getArguments()[0]);
        if (item == null || !MyGame.getInstance().getPlayer().dropItem(item)) {
            System.out.println("Cannot find item!");
            System.out.println("Use 'inventory' to see the items you have with you.");
            return;
        }
        System.out.println("You have dropped " + item.getName() + ".");
        System.out.println("Use 'search' to see what items are in your current room.");
    }

    private static GameEnding solve(Command command) {
        GameEnding ending;
        if (command.getArguments().length != 3) {
            command.getCommand().printUsage();
            return null;
        }
        if (MyGame.getInstance().getPlayer().isPastPlayer()) {
            System.out.println("This command cannot be used in the past!");
            System.out.println("Please go back to the present in order to solve the murder.");
            return null;
        }
        LostPerson person = PersonManager.getLostPerson(command.getArguments()[0]);
        if (person == null) {
            System.out.println("Invalid person!");
            return null;
        }
        Item item = ItemManager.getItem(command.getArguments()[1]);
        if (item == null) {
            System.out.println("Invalid item!");
            return null;
        }
        Room room = RoomManager.getRoom(command.getArguments()[2]);
        if (room == null) {
            System.out.println("Invalid room!");
            return null;
        }
        GameEnding gameEnding = Solution.isSolution(person, item, room) ? GameEnding.WIN : (ending = MyGame.getInstance().useAttempt() ? null : GameEnding.LOSE);
        if (ending == null) {
            System.out.println("You're wrong, that isn't right!");
            System.out.println("You can try " + MyGame.getInstance().getRemainingAttempts() + " more times.");
        }
        return ending;
    }

    private static boolean quit(Command command) {
        if (command.getArguments().length == 1 && command.getArguments()[0].contains("y")) {
            System.out.println("I'm very sad to hear that. Well bye...");
            return true;
        }
        System.out.println("Are you sure you want to quit? All your progress will be lost!");
        System.out.print("\u27a4 ");
        Scanner scanner = new Scanner(System.in);
        String input = scanner.nextLine().toLowerCase();
        if (input.contains("n")) {
            System.out.println("That's what I thought. Let's continue!");
            scanner.close();
            return false;
        }
        if (input.contains("y")) {
            System.out.println("I'm very sad to hear that. Well bye...");
            scanner.close();
            return true;
        }
        System.out.println("You are supposed to answer with yes or no. Let's try that again!");
        scanner.close();
        return CommandProcessor.quit(command);
    }
}

