/*
 * Decompiled with CFR 0.152.
 */
package be.jorenfabre.mygame.commands;

public enum CommandWord {
    GO("Go to another room.", 1, "go <direction>"),
    LOOK("Look at the room and it's exits."),
    SEARCH("Search for items in the room."),
    SEE("See and list the people in the room."),
    BACK("Go back to the previous room."),
    BACK_MULTI("back", "Go back multiple rooms.", 1, "back <amount>"),
    HELP("Display the list of commands."),
    HELP_COMMAND("help", "Display information about a specific command.", 1, "help <command>"),
    UNLOCK("Unlock an exit using an item.", 2, "unlock <direction> <item>"),
    INVENTORY("Display all the items in your inventory."),
    PICKUP("Pick up an item from the room that you are currently in.", 1, "pickup <item>"),
    DROP("Drop an item from your inventory on the ground.", 1, "drop <item>"),
    SOLVE("Solve the murder.", 3, "solve <murderer> <weapon> <room>"),
    QUIT("Quit the game without solving the murder.");

    private String name;
    private String description;
    private int arguments;
    private String usage;

    private CommandWord(String description) {
        this(null, description, 0, null);
    }

    private CommandWord(String description, int arguments, String usage) {
        this(null, description, arguments, usage);
    }

    private CommandWord(String name, String description, int arguments, String usage) {
        this.name = name;
        this.description = description;
        this.arguments = arguments;
        this.usage = usage;
    }

    public String getName() {
        return this.name == null ? this.name().toLowerCase() : this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getArguments() {
        return this.arguments;
    }

    public String getUsage() {
        return this.usage == null ? this.getName() : this.usage;
    }

    public void printUsage() {
        System.out.println("Invalid arguments!\nUsage: " + this.getUsage());
        if (this.name().equals("BACK")) {
            System.out.println("OR " + BACK_MULTI.getUsage());
        }
        if (this.name().equals("HELP")) {
            System.out.println("OR " + HELP_COMMAND.getUsage());
        }
    }
}

