/*
 * Decompiled with CFR 0.152.
 */
package be.jorenfabre.mygame.entities;

import be.jorenfabre.mygame.MyGame;
import be.jorenfabre.mygame.entities.Item;
import be.jorenfabre.mygame.entities.Person;
import be.jorenfabre.mygame.map.Room;
import be.jorenfabre.mygame.map.exit.Exit;
import be.jorenfabre.mygame.map.exit.ExitDirection;
import be.jorenfabre.mygame.map.exit.ExitRequirement;
import be.jorenfabre.mygame.utilities.ItemManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;

public class Player
extends Person {
    private static final double MAX_INVENTORY_WEIGHT = 10.0;
    private Stack<Exit> backStack = new Stack();
    private List<Item> inventory = new ArrayList<Item>();
    private double inventoryWeight = 0.0;
    private boolean pastPlayer;

    public Player(String name, Room startRoom, boolean past) {
        super("player", name, startRoom);
        this.pastPlayer = past;
    }

    public boolean isPastPlayer() {
        return this.pastPlayer;
    }

    public void goDirection(ExitDirection direction) {
        if (direction == null) {
            System.out.println("Unknown direction!");
            System.out.println("Use 'look' to see all exits in this room.");
            return;
        }
        if (!this.getCurrentRoom().isExit(direction)) {
            System.out.println("There is no exit that way!");
            System.out.println("Use 'look' to see all exits in this room.");
            return;
        }
        Exit exit = this.getCurrentRoom().getExit(direction);
        if (exit.isLocked()) {
            if (exit.getRequirement() == ExitRequirement.WRONG_WAY) {
                System.out.println("This door seems to only open from the other side.");
                System.out.println("You should try going another direction.");
            } else {
                System.out.println("That exit is locked!");
                System.out.println("You can try unlocking it using 'unlock'.");
            }
            return;
        }
        if (exit.getRequirement() == ExitRequirement.PORTAL_ACCESS) {
            exit.setLocked();
            MyGame.getInstance().passPortal();
            this.backStack.clear();
            System.out.println("You pass through the portal.");
            System.out.println();
            Player player = MyGame.getInstance().getPlayer();
            if (player.isPastPlayer()) {
                System.out.println("When you open your eyes you find that the world seems... frozen!?");
                System.out.println("You vaguely remember going through a portal.");
                System.out.println("That portal you unlocked using the Talisman of The Past.");
                System.out.println("Suddenly you hear a voice:");
                System.out.println("  \"Welcome " + player.getName() + ".\"");
                System.out.println("  \"You are now in a frozen moment, minutes before the murder happened.\"");
                System.out.println("  \"Use the information you gather here to find the murderer.\"");
                System.out.println("  \"To return to the regular world you will have to re-find the Talisman,");
                System.out.println("      re-open the portal and go through it again from this side.\"");
                System.out.println("  \"Be sure to find every detail you need before leaving.\"");
                System.out.println("  \"Once you return to your time you won't be able to get back here.\"");
                System.out.println("  \"Good luck!\"");
                System.out.println();
                System.out.println("After the voice stops talking you notice that you no longer have any items with you.");
                System.out.println("You decide to do what the voice said and start looking for the Talisman, and the murderer.");
            } else {
                System.out.println("You open your eyes and notice that you're back in the regular world.");
                System.out.println("And there is that strange voice again:");
                System.out.println("  \"Welcome back " + player.getName() + ".\"");
                System.out.println("  \"Did you find what you were looking for?\"");
                System.out.println("  \"You better have, because there is no way back now!\"");
                System.out.println("As expected you find all items you had previously gathered to be back in your possession.");
            }
            return;
        }
        this.setCurrentRoom(exit.getRoom());
        this.backStack.add(exit.getOpposite());
        System.out.printf("%nYou pass through the door on the %s side of the room.%n", direction.name().toLowerCase());
    }

    public Exit goBack() {
        if (this.backStack.isEmpty()) {
            return null;
        }
        Exit exit = this.backStack.peek();
        if (exit.isLocked()) {
            return exit;
        }
        this.setCurrentRoom(this.backStack.pop().getRoom());
        return exit;
    }

    public boolean hasInventoryItem(Item item) {
        for (Item inventoryItem : this.inventory) {
            if (!inventoryItem.equals(item)) continue;
            return true;
        }
        return false;
    }

    public boolean pickupItem(Item item) {
        if (this.inventoryWeight + item.getWeight() > 10.0) {
            return false;
        }
        if (!this.getCurrentRoom().removeItem(item)) {
            return false;
        }
        this.inventoryWeight += item.getWeight();
        this.inventory.add(item);
        return true;
    }

    public boolean dropItem(Item item) {
        if (!this.inventory.contains(item)) {
            return false;
        }
        this.inventoryWeight -= item.getWeight();
        this.inventory.remove(item);
        this.getCurrentRoom().addItem(item);
        return true;
    }

    public void printInventory() {
        System.out.println("--==-- YOUR INVENTORY --==--");
        if (this.inventory.isEmpty()) {
            System.out.println("None.");
        } else {
            for (Item item : this.inventory) {
                System.out.println(item);
            }
        }
    }

    public void breakTalisman() {
        if (!this.inventory.contains(ItemManager.TALISMAN)) {
            return;
        }
        this.inventoryWeight -= ItemManager.TALISMAN.getWeight();
        this.inventory.remove(ItemManager.TALISMAN);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Player player = (Player)o;
        return Double.compare(player.inventoryWeight, this.inventoryWeight) == 0 && this.pastPlayer == player.pastPlayer && this.backStack.equals(player.backStack) && this.inventory.equals(player.inventory);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.backStack, this.inventory, this.inventoryWeight, this.pastPlayer);
    }
}

