/*
 * Decompiled with CFR 0.152.
 */
package be.jorenfabre.mygame.map;

import be.jorenfabre.mygame.entities.Item;
import be.jorenfabre.mygame.map.exit.Exit;
import be.jorenfabre.mygame.map.exit.ExitDirection;
import be.jorenfabre.mygame.map.exit.ExitRequirement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Room {
    private String name;
    private String description;
    private Map<ExitDirection, Exit> exits = new HashMap<ExitDirection, Exit>();
    private List<Item> items = new ArrayList<Item>();

    public void setDetails(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.getName().split(" ")[0];
    }

    public boolean isExit(ExitDirection direction) {
        return this.exits.containsKey((Object)direction);
    }

    public Exit getExit(ExitDirection direction) {
        return this.exits.get((Object)direction);
    }

    public void setExit(ExitDirection direction, Room room) {
        this.setExit(direction, ExitRequirement.NONE, room);
    }

    public void setExit(ExitDirection direction, ExitRequirement requirement, Room room) {
        this.exits.put(direction, new Exit(room, direction, requirement));
    }

    public void addItem(Item item) {
        this.items.add(item);
    }

    public boolean hasItem(Item item) {
        return this.items.contains(item);
    }

    public boolean removeItem(Item item) {
        return this.items.remove(item);
    }

    public void printItems() {
        System.out.println("--==-- ITEMS --==--");
        if (this.items.isEmpty()) {
            System.out.println("None.");
        } else {
            for (Item item : this.items) {
                System.out.println(item);
            }
        }
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(String.format("You are currently in the %s.\n%s\n\nExits: ", this.name, this.description));
        this.exits.forEach((direction, exit) -> {
            ret.append("\n - ").append(direction.name().toLowerCase()).append(": ").append(exit.getRoom().getName());
            if (exit.isLocked()) {
                ret.append(" (Locked)");
            }
        });
        return ret.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Room room = (Room)o;
        return this.name.equals(room.name) && this.description.equals(room.description);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description);
    }

    public List<Item> getItems() {
        return this.items;
    }
}

