/*
 * Decompiled with CFR 0.152.
 */
package be.jorenfabre.mygame.map.exit;

import be.jorenfabre.mygame.map.Room;
import be.jorenfabre.mygame.map.exit.ExitDirection;
import be.jorenfabre.mygame.map.exit.ExitRequirement;

public class Exit {
    private Room room;
    private ExitDirection direction;
    private ExitRequirement requirement;
    private boolean locked;

    public Exit(Room room, ExitDirection direction, ExitRequirement requirement) {
        this.room = room;
        this.direction = direction;
        this.requirement = requirement;
        this.locked = requirement != ExitRequirement.NONE;
    }

    public Room getRoom() {
        return this.room;
    }

    public ExitDirection getDirection() {
        return this.direction;
    }

    public Exit getOpposite() {
        return this.getRoom().getExit(this.direction.getOpposite());
    }

    public ExitRequirement getRequirement() {
        return this.requirement;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked() {
        this.locked = true;
    }

    public void setUnlocked() {
        this.locked = false;
    }

    public String toString() {
        return "Exit{, toRoom=" + this.room.getName() + ", direction=" + this.direction.name() + ", requirement=" + this.requirement.name() + ", locked=" + this.locked + "}";
    }
}

