/*
 * Decompiled with CFR 0.152.
 */
package be.jorenfabre.mygame.utilities;

import be.jorenfabre.mygame.entities.Item;
import be.jorenfabre.mygame.map.Room;
import be.jorenfabre.mygame.utilities.RoomManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ItemManager {
    public static final Item KEY = new Item("key", "Key", "The key meant for residents.", 0.5);
    public static final Item STAFF_KEY = new Item("staffkey", "Staff Key", "The key to staff-only rooms.", 0.5);
    public static final Item KEY_CARD = new Item("keycard", "Key Card", "The card that grants access to the owner's study.", 1.0);
    public static final Item TALISMAN = new Item("talisman", "Talisman of The Past", "This talisman grants access to the past. (Needs a portal to function!)", 2.5);
    private static final Item CANDLESTICK = new Item("candlestick", "The Silver Candlestick", "The very expensive and quite heavy Silver Candlestick that holds the Easter Candle.", 5.0);
    private static final Item DAGGER = new Item("dagger", "The Rusty Dagger", "A family heirloom from 1781, when it saved the life of Dr. Black's ancestor.", 0.5);
    private static final Item PIPE = new Item("pipe", "A Heavy Lead Pipe", "A Lead Pipe that Dr. Black was going to use to fix his sink.", 2.5);
    private static final Item REVOLVER = new Item("revolver", "Dr. Black's Revolver", "The Revolver that never left Dr. Black's side.", 3.0);
    private static final Item ROPE = new Item("rope", "A Rope", "An ordinary Rope", 1.5);
    private static final Item WRENCH = new Item("wrench", "The Wrench", "The Wrench meant for screwing and unscrewing pipes.", 4.5);
    private static List<Item> weapons = new ArrayList<Item>(List.of(CANDLESTICK, DAGGER, PIPE, REVOLVER, ROPE, WRENCH));
    private static List<Item> keys = new ArrayList<Item>(List.of(KEY, STAFF_KEY, KEY_CARD, TALISMAN));

    public static void spawnItems() {
        Random random = new Random();
        for (Item item : weapons) {
            Room room = RoomManager.getRoom(random);
            room.addItem(item);
            RoomManager.getOtherRoom(room, true).addItem(item);
        }
    }

    public static void makeKillRoom(Room room, Item item) {
        Room wrongRoom = RoomManager.getRoom(item);
        if (wrongRoom != null) {
            wrongRoom.removeItem(item);
            RoomManager.getOtherRoom(wrongRoom, false).removeItem(item);
        }
        room.addItem(item);
        Room entrance = RoomManager.getRoom("entrance");
        if (entrance != null) {
            entrance.addItem(item);
        }
    }

    public static Item getItem(String id) {
        for (Item item : weapons) {
            if (!item.getId().equals(id)) continue;
            return item;
        }
        for (Item item : keys) {
            if (!item.getId().equals(id)) continue;
            return item;
        }
        return null;
    }

    public static Item getItem(Random random) {
        return weapons.get(random.nextInt(weapons.size()));
    }
}

