/*
 * Decompiled with CFR 0.152.
 */
package be.jorenfabre.mygame.utilities;

import be.jorenfabre.mygame.entities.LostPerson;
import be.jorenfabre.mygame.entities.Person;
import be.jorenfabre.mygame.map.Room;
import be.jorenfabre.mygame.utilities.RoomManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class PersonManager {
    private static final LostPerson BLACK = new LostPerson("black", "Dr. Black");
    private static final LostPerson RED = new LostPerson("red", "Miss Scarlett");
    private static final LostPerson GREEN = new LostPerson("green", "Mr. Green");
    private static final LostPerson YELLOW = new LostPerson("yellow", "Colonel Mustard");
    private static final LostPerson PURPLE = new LostPerson("purple", "Professor Plum");
    private static final LostPerson BLUE = new LostPerson("blue", "Mrs. Peacock");
    private static final LostPerson WHITE = new LostPerson("white", "Mrs. White");
    private static List<LostPerson> people = new ArrayList<LostPerson>(List.of(RED, GREEN, YELLOW, PURPLE, BLUE, WHITE));

    private static void movePerson(LostPerson person, Room room) {
        people.remove(person);
        people.add(new Person(person, room));
    }

    public static void spawnPeople() {
        Random random = new Random();
        ArrayList<LostPerson> copy = new ArrayList<LostPerson>(people);
        for (LostPerson person : copy) {
            PersonManager.movePerson(person, RoomManager.getRoom(random));
        }
    }

    public static void makeKillRoom(Room room, LostPerson person) {
        PersonManager.clearRoom(room);
        PersonManager.movePerson(person, room);
        PersonManager.movePerson(BLACK, room);
    }

    private static void clearRoom(Room room) {
        Random random = new Random();
        while (!PersonManager.getPeopleInRoom(room).isEmpty()) {
            PersonManager.movePerson(PersonManager.getPeopleInRoom(room).get(0), RoomManager.getRoom(random));
        }
    }

    public static LostPerson getLostPerson(String name) {
        for (LostPerson person : people) {
            if (!person.getId().equalsIgnoreCase(name)) continue;
            return person;
        }
        return null;
    }

    public static LostPerson getLostPerson(Random random) {
        return people.get(random.nextInt(people.size()));
    }

    public static List<Person> getPeopleInRoom(Room room) {
        ArrayList<Person> peopleInRoom = new ArrayList<Person>();
        for (LostPerson lostPerson : people) {
            Person person;
            if (!(lostPerson instanceof Person) || !(person = (Person)lostPerson).getCurrentRoom().equals(room)) continue;
            peopleInRoom.add(person);
        }
        return peopleInRoom;
    }
}

