/*
 * Decompiled with CFR 0.152.
 */
package be.jorenfabre.mygame.utilities;

import be.jorenfabre.mygame.entities.Item;
import be.jorenfabre.mygame.map.Room;
import be.jorenfabre.mygame.map.exit.ExitDirection;
import be.jorenfabre.mygame.map.exit.ExitRequirement;
import be.jorenfabre.mygame.utilities.ItemManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class RoomManager {
    private static List<Room> rooms = new ArrayList<Room>();
    private static List<Room> pastRooms = new ArrayList<Room>();

    public static Room createRooms(boolean past) {
        Room kitchen = new Room();
        Room ballroom = new Room();
        Room storage = new Room();
        Room diningRoom = new Room();
        Room hallway = new Room();
        Room gameRoom = new Room();
        Room library = new Room();
        Room lounge = new Room();
        Room entrance = new Room();
        Room study = new Room();
        Room yard = new Room();
        Room unknown = new Room();
        kitchen.setDetails("kitchen", "Here the staff prepare meals for everyone lucky enough to be invited over.");
        ballroom.setDetails("ball room", "Any number of large parties are held in this room.");
        storage.setDetails("storage", "This is where all unused objects get stored until they are used or sold.");
        diningRoom.setDetails("dining room", "In this room the occupants of the mansion eat their meals.");
        hallway.setDetails("hallway", "The hallway is the hub of the house, you can go almost everywhere from here.");
        gameRoom.setDetails("game room", "A huge mansion like this one obviously needs a room dedicated to games of all kinds.");
        library.setDetails("library", "This library contains amazing amounts of information about various subjects.");
        lounge.setDetails("lounge", "Visitors are often invited into this room for casual conversations.");
        entrance.setDetails("entrance", "The mansion's impressive front door is located in this room, allowing access to the yard.");
        study.setDetails("study", "Though this is where the mansion's owner sleeps, he prefers it be called his study.");
        yard.setDetails("yard", "A large grass field is covered with perfectly managed bushes and flowers.");
        unknown.setDetails("unknown", "An unknown room");
        kitchen.setExit(ExitDirection.SOUTH, ExitRequirement.STAFF_KEY, diningRoom);
        kitchen.setExit(ExitDirection.EAST, ExitRequirement.STAFF_KEY, ballroom);
        kitchen.setExit(ExitDirection.SOUTHEAST, ExitRequirement.WRONG_WAY, hallway);
        ballroom.setExit(ExitDirection.WEST, ExitRequirement.STAFF_KEY, kitchen);
        ballroom.setExit(ExitDirection.SOUTH, hallway);
        storage.setExit(ExitDirection.SOUTHWEST, ExitRequirement.STAFF_KEY, hallway);
        diningRoom.setExit(ExitDirection.NORTH, ExitRequirement.STAFF_KEY, kitchen);
        diningRoom.setExit(ExitDirection.EAST, hallway);
        diningRoom.setExit(ExitDirection.SOUTH, lounge);
        hallway.setExit(ExitDirection.NORTHWEST, ExitRequirement.STAFF_KEY, kitchen);
        hallway.setExit(ExitDirection.NORTH, ballroom);
        hallway.setExit(ExitDirection.NORTHEAST, ExitRequirement.STAFF_KEY, storage);
        hallway.setExit(ExitDirection.WEST, diningRoom);
        hallway.setExit(ExitDirection.PORTAL, ExitRequirement.PORTAL_ACCESS, unknown);
        hallway.setExit(ExitDirection.EAST, gameRoom);
        hallway.setExit(ExitDirection.SOUTH, entrance);
        gameRoom.setExit(ExitDirection.WEST, hallway);
        gameRoom.setExit(ExitDirection.SOUTH, ExitRequirement.KEY, library);
        library.setExit(ExitDirection.NORTH, ExitRequirement.KEY, gameRoom);
        library.setExit(ExitDirection.SOUTH, ExitRequirement.KEY_CARD, study);
        lounge.setExit(ExitDirection.NORTH, diningRoom);
        lounge.setExit(ExitDirection.WEST, entrance);
        entrance.setExit(ExitDirection.NORTH, hallway);
        entrance.setExit(ExitDirection.WEST, lounge);
        entrance.setExit(ExitDirection.EAST, ExitRequirement.KEY_CARD, study);
        entrance.setExit(ExitDirection.SOUTH, ExitRequirement.KEY, yard);
        study.setExit(ExitDirection.NORTH, ExitRequirement.WRONG_WAY, library);
        study.setExit(ExitDirection.WEST, ExitRequirement.KEY_CARD, entrance);
        yard.setExit(ExitDirection.NORTH, ExitRequirement.KEY, entrance);
        unknown.setExit(ExitDirection.PORTAL, ExitRequirement.WRONG_WAY, hallway);
        if (past) {
            lounge.addItem(ItemManager.KEY);
            study.addItem(ItemManager.STAFF_KEY);
            library.addItem(ItemManager.KEY_CARD);
            kitchen.addItem(ItemManager.TALISMAN);
        } else {
            storage.addItem(ItemManager.KEY);
            gameRoom.addItem(ItemManager.STAFF_KEY);
            yard.addItem(ItemManager.KEY_CARD);
            study.addItem(ItemManager.TALISMAN);
        }
        (past ? pastRooms : rooms).addAll(List.of(kitchen, ballroom, storage, diningRoom, hallway, gameRoom, library, lounge, entrance, study, yard));
        return past ? hallway : entrance;
    }

    public static Room getRoom(String name) {
        for (Room room : rooms) {
            if (!room.getShortName().equalsIgnoreCase(name)) continue;
            return room;
        }
        return null;
    }

    public static Room getRoom(Random random) {
        return pastRooms.get(random.nextInt(pastRooms.size()));
    }

    public static Room getRoom(Item item) {
        for (Room room : rooms) {
            if (!room.hasItem(item)) continue;
            return room;
        }
        return null;
    }

    public static Room getOtherRoom(Room room, boolean past) {
        if (room == null) {
            return null;
        }
        for (Room otherRoom : past ? rooms : pastRooms) {
            if (!room.equals(otherRoom)) continue;
            return otherRoom;
        }
        return null;
    }
}

